local t = Def.ActorFrame{};

local ChoiceNames;
if GAMESTATE:GetCoinMode() == "CoinMode_Home" then
	ChoiceNames = {"Normal","Rave","Nonstop","Endless"};
else
	if GAMESTATE:GetNumSidesJoined() > 1 then
		ChoiceNames = {"Normal","Rave","Nonstop","Endless"};
	else
		ChoiceNames = {"Arcade","Normal","Nonstop","Endless"};
	end;
end;
local numChoices = #ChoiceNames;
local a = {
["Normal"] = "Arcueid",
["Rave"] = "HisuiAndKohaku",
["Arcade"] = "TohnoShiki",
["Hazard"] = "ArchetypeEarth",
["Nonstop"] = "Dust",
["Endless"] = "SionEltnam"
}

local selection = 1;
local selectedHazard = false
--Sorry about the mess
chr = Def.ActorFrame{
	CodeMessageCommand=function(self, param)
		if param.Name == "Left" and selection > 1 then
			SOUND:PlayOnce(THEME:GetPathS("Common","value"),true);
			if selectedHazard then
				self:GetChild("Hazard"):playcommand("Hide");
				self:GetChild(ChoiceNames[selection]):playcommand("Show")
				selectedHazard = false
			end;
			self:GetChild(ChoiceNames[selection]):playcommand("LoseFocus")
			selection = selection - 1;
			self:GetChild(ChoiceNames[selection]):playcommand("GainFocus")
		elseif param.Name == "Right" and selection < numChoices then
			SOUND:PlayOnce(THEME:GetPathS("Common","value"),true);
			if selectedHazard then
				self:GetChild("Hazard"):playcommand("Hide");
				self:GetChild(ChoiceNames[selection]):playcommand("Show")
				selectedHazard = false;
			end;
			self:GetChild(ChoiceNames[selection]):playcommand("LoseFocus")
			selection = selection + 1;
			self:GetChild(ChoiceNames[selection]):playcommand("GainFocus")
		elseif param.Name == "Up" and ChoiceNames[selection] == "Normal" then
			if selectedHazard then
				selectedHazard = false
				self:GetChild(ChoiceNames[selection]):queuecommand("Show");
				self:GetChild("Hazard"):queuecommand("Hide")
			else
				selectedHazard = true;
				self:GetChild(ChoiceNames[selection]):queuecommand("Hide");
				self:GetChild("Hazard"):queuecommand("Show")
				SOUND:PlayOnce(THEME:GetPathS("","Hazard"),true);
			end;
		elseif param.Name == "Start" then
			--Surely there's a better way to do this?
			if selectedHazard then
				GAMESTATE:SetCurrentPlayMode("PlayMode_Regular");
				--sMode seems to be a relic of the 3.9 days, since everything works fine
				--even if it's not set. In this case, using it to determine Hazard mode
				--probably shouldn't cause issues.
				setenv("sMode","Hazard");
				SCREENMAN:GetTopScreen():SetNextScreenName("ScreenSelectMusic");
			elseif ChoiceNames[selection] == "Normal" then
				--I have no idea what applydefaultoptions is in metrics but it's not a function
				--applydefaultoptions();
				GAMESTATE:SetCurrentPlayMode("PlayMode_Regular");
				setenv("sMode","Normal");
				--SCREENMAN:SetNewScreen("ScreenSelectMusic");
				SCREENMAN:GetTopScreen():SetNextScreenName("ScreenSelectMusic");
			elseif ChoiceNames[selection] == "Rave" then
				--GAMESTATE:SetCurrentPlayMode("PlayMode_Rave");
				--setenv("sMode","Rave");
				--If the current style isn't Versus, it will silently set the playmode to Regular instead
				assert(GAMESTATE:GetCurrentStyle() and GAMESTATE:GetCurrentStyle():GetName() == "Versus","The current style isn't set to Versus. Cannot enter Rave Mode.");
				GAMESTATE:ApplyGameCommand("applydefaultoptions;playmode,rave;setenv,sMode,Rave");
				SCREENMAN:GetTopScreen():SetNextScreenName("ScreenSelectMusic");
			elseif ChoiceNames[selection] == "Nonstop" then
				GAMESTATE:SetCurrentPlayMode("PlayMode_Nonstop");
				setenv("sMode","Nonstop");
				SCREENMAN:GetTopScreen():SetNextScreenName("ScreenSelectCourse");
			elseif ChoiceNames[selection] == "Endless" then
				GAMESTATE:SetCurrentPlayMode("PlayMode_Endless");
				setenv("sMode","Endless");
				SCREENMAN:GetTopScreen():SetNextScreenName("ScreenSelectCourse");
			elseif ChoiceNames[selection] == "Arcade" then
				SCREENMAN:GetTopScreen():SetNextScreenName(EnterArcadeMode());
			else
				lua:ReportScriptError("No parameters have been set for the screen "..ChoiceNames[selection]..", so I've returned you to the main menu to prevent crashing.","LUA_ERROR");
				SCREENMAN:GetTopScreen():SetNextScreenName("ScreenTitleMB");
			end;
			SOUND:PlayOnce(THEME:GetPathS("","accept"),true);
			SCREENMAN:GetTopScreen():StartTransitioningScreen("SM_GoToNextScreen");
		elseif param.Name == "Back" then
			SCREENMAN:GetTopScreen():StartTransitioningScreen("SM_GoToPrevScreen");
		end;
		if selectedHazard then
			self:GetChild("Title"):settext("Hazard"):diffusebottomedge(Color("Red"));
			self:GetChild("Description"):settext(THEME:GetString("ScreenSelectPlayMode","Hazard"));
		else
			self:GetChild("Description"):settext(THEME:GetString("ScreenSelectPlayMode",ChoiceNames[selection]));
			self:GetChild("Title"):settext(ChoiceNames[selection]):diffusebottomedge(Color("Blue"));
		end;
		--SCREENMAN:SystemMessage(selection.." "..param.Name);
	end;
}
for i = 1,numChoices do
	chr[#chr+1] = Def.ActorFrame{
		Name=ChoiceNames[i];
		InitCommand=cmd(zoom,.75;xy,SCREEN_WIDTH/numChoices*i-SCREEN_WIDTH/numChoices/2,SCREEN_CENTER_Y;);
		OnCommand=function(self)
			if i == selection then
				self:playcommand("GainFocus");
			else
				self:playcommand("LoseFocus")
			end;
		end;
		GainFocusCommand=cmd(diffuse,Color("White"));
		LoseFocusCommand=cmd(diffuse,color("#888888"));
		HideCommand=cmd(stoptweening;decelerate,.3;rotationy,90);
		ShowCommand=cmd(stoptweening;rotationy,90;sleep,.3;decelerate,.3;rotationy,0);

		LoadActor(THEME:GetPathG("","portrait_"..a[ChoiceNames[i]]))..{
			InitCommand=cmd(addx,50);
		};
		--[[Def.Quad{
			InitCommand=cmd(setsize,50,SCREEN_HEIGHT);
		};]]
	};
end;
chr[#chr+1] = LoadActor(THEME:GetPathG("","portrait_"..a["Hazard"]))..{
	Name="Hazard";
	InitCommand=cmd(zoom,.75;y,SCREEN_CENTER_Y;rotationy,90);
	OnCommand=function(self)
		self:x(self:GetParent():GetChild("Normal"):GetX());
	end;
	GainFocusCommand=cmd(diffuse,Color("White"));
	LoseFocusCommand=cmd(diffuse,color("#888888"));
	HideCommand=cmd(stoptweening;decelerate,.3;rotationy,90);
	ShowCommand=cmd(stoptweening;rotationy,90;sleep,.3;decelerate,.3;rotationy,0)
};

chr[#chr+1] = Def.Quad{
		InitCommand=cmd(setsize,SCREEN_WIDTH/4,35;xy,SCREEN_CENTER_X,SCREEN_HEIGHT*.75;diffuse,color("0,0,0,.8");fadeleft,.5;faderight,.5);
	};
	
chr[#chr+1] = Def.Quad{
		InitCommand=cmd(setsize,SCREEN_WIDTH,35;xy,SCREEN_CENTER_X,SCREEN_HEIGHT*.80;diffuse,color("0,0,0,.8"));
	};

chr[#chr+1] = LoadFont("Common Label")..{
	Name="Title";
	Text=ChoiceNames[1];
	InitCommand=cmd(xy,SCREEN_CENTER_X,SCREEN_HEIGHT*.75;diffusebottomedge,Color("Blue"));
};
chr[#chr+1] = LoadFont("Common Normal")..{
		Name="Description";
		Text=THEME:GetString("ScreenSelectPlayMode",ChoiceNames[1]);
		InitCommand=cmd(xy,SCREEN_CENTER_X,SCREEN_HEIGHT*.80;);
	};


t[#t+1] = chr;
return t;